/********************************************
; File: Menu.h
;
;
; Copyright Apple Computer, Inc.1986-90
; All Rights Reserved
;
********************************************/
#ifndef __TYPES__
#include <TYPES.h>
#endif

#ifndef __QUICKDRAW__
#include <QUICKDRAW.h>
#endif

#ifndef __EVENT__
#include <EVENT.h>
#endif

#ifndef __CONTROL__
#include <CONTROL.h>
#endif

#ifndef __WINDOW__
#include <WINDOW.h>
#endif

#ifndef __MENU__
#define __MENU__


/* MenuDefProc Codes */
#define mDrawMsg 0x0000
#define mChooseMsg 0x0001
#define mSizeMsg 0x0002
#define mDrawTitle 0x0003
#define mDrawMItem 0x0004
#define mGetMItemID 0x0005

/* Reference Flags */
#define menuRefPtr 0x0000
#define mRefHandle 0x4000
#define mRefResource 0x8000

/* Menu Flags */
#define menuAllowCache 0x0008
#define menuCustom 0x0010
#define menuXOR 0x0020
#define menuDisabled 0x0080
#define menuAlwaysCallMChoose 0x0100

/* Item Flags */
#define itemBold 0x0001
#define itemItalic 0x0002
#define itemUnderline 0x0004
#define itemXOR 0x0020
#define itemDivider 0x0040
#define itemDisabled 0x0080
#define itemOutline 0x0800
#define itemShadow 0x1000

/* Old Menu Flags */
#define mInvis 0x0004
#define mCustom 0x0010
#define mXor 0x0020
#define mSelected 0x0040
#define mDisabled 0x0080

/* MenuFlag Masks */
#define menuCacheMask 0x0008
#define customMenu 0x0010
#define xorMItemHilite 0x0020
#define xorTitleHilite 0x0020
#define underMItem 0x0040
#define disableItem 0x0080
#define disableMenu 0x0080
#define enableItem 0xFF7F
#define enableMenu 0xFF7F
#define noUnderMItem 0xFFBF
#define colorMItemHilite 0xFFDF
#define colorTitleHilite 0xFFDF
#define colorReplace 0xFFDF
#define standardMenu 0xFFEF

/* Other misc constants */
#define type2 0x0040
#ifndef mtItemRefArrayLength  /* MenuTemplate - default number of Ref's */
#define mtItemRefArrayLength 0x0005
#endif
#ifndef mbtMenuRefArrayLength  /* MenuBarTemplate - default number of Ref's */
#define mbtMenuRefArrayLength 0x0005
#endif
typedef CtlRec MenuBarRec, *MenuBarRecPtr, **MenuBarRecHndl;
struct MenuRec {
   Word menuID; /* Menu's ID number */
   Word menuWidth; /* Width of menu */
   Word menuHeight; /* Height of menu */
   WordProcPtr menuProc; /* Menu's definition procedure */
   Word menuFlag; /* Bit flags */
   Word numOfItems;
   Word titleWidth; /* Width of menu's title */
   Pointer titleName;
   Handle menuCache;
} ;
typedef struct MenuRec MenuRec, *MenuRecPtr, **MenuRecHndl;
struct MenuItemTemplate {
   Word version; /* Version number (must be 0) */
   Word itemID; /* Menu item ID */
   Byte itemChar; /* Primary keystroke character */
   Byte itemAltChar; /* Alternate keystroke character */
   Word itemCheck; /* Character code for checked items */
   Word itemFlag; /* Menu item flag word */
   Ref itemTitleRef; /* Reference to item title string */
} ;
typedef struct MenuItemTemplate MenuItemTemplate;
struct MenuTemplate {
   Word version; /* Version number (must be 0) */
   Word menuID; /* Menu ID */
   Word menuFlag; /* Menu flag word */
   Ref menuTitleRef; /* Reference to menu title string */
   Ref itemRefArray[mtItemRefArrayLength]; /* mtItemRefArrayLength references to menu items  */
} ;
typedef struct MenuTemplate MenuTemplate;
struct MenuBarTemplate {
   Word version; /* Version number (must be 0) */
   Word menuFlag; /* MenuBar flag word */
   Ref menuRefArray[mbtMenuRefArrayLength]; /* mbtMenuRefArrayLength references to menus */
} ;
typedef struct MenuBarTemplate MenuBarTemplate;
extern pascal void CalcMenuSize() inline(0x1C0F,dispatcher);
extern pascal void CheckMItem() inline(0x320F,dispatcher);
extern pascal Word CountMItems() inline(0x140F,dispatcher);
extern pascal void DeleteMenu() inline(0x0E0F,dispatcher);
extern pascal void DeleteMItem() inline(0x100F,dispatcher);
extern pascal void DisableMItem() inline(0x310F,dispatcher);
extern pascal void DisposeMenu() inline(0x2E0F,dispatcher);
extern pascal void DrawMenuBar() inline(0x2A0F,dispatcher);
extern pascal void EnableMItem() inline(0x300F,dispatcher);
extern pascal Word FixMenuBar () inline(0x130F,dispatcher);
extern pascal void FlashMenuBar () inline(0x0C0F,dispatcher);
extern pascal LongWord GetBarColors () inline(0x180F,dispatcher);
extern pascal MenuBarRecHndl GetMenuBar () inline(0x0A0F,dispatcher);
extern pascal Word GetMenuFlag () inline(0x200F,dispatcher);
extern pascal GrafPortPtr GetMenuMgrPort () inline(0x1B0F,dispatcher);
extern pascal Pointer GetMenuTitle () inline(0x220F,dispatcher);
extern pascal MenuRecHndl GetMHandle () inline(0x160F,dispatcher);
extern pascal StringPtr GetMItem () inline(0x250F,dispatcher);
extern pascal Word GetMItemFlag () inline(0x270F,dispatcher);
extern pascal Word GetMItemMark () inline(0x340F,dispatcher);
extern pascal TextStyle GetMItemStyle () inline(0x360F,dispatcher);
extern pascal Word GetMTitleStart () inline(0x1A0F,dispatcher);
extern pascal Word GetMTitleWidth () inline(0x1E0F,dispatcher);
extern pascal Pointer GetPopUpDefProc () inline(0x3B0F,dispatcher);
extern pascal MenuBarRecHndl GetSysBar () inline(0x110F,dispatcher);
extern pascal void HideMenuBar () inline(0x450F,dispatcher);
extern pascal void HiliteMenu () inline(0x2C0F,dispatcher);
extern pascal void InitPalette () inline(0x2F0F,dispatcher);
extern pascal void InsertMenu () inline(0x0D0F,dispatcher);
extern pascal void InsertMItem () inline(0x0F0F,dispatcher);
extern pascal void InsertMItem2() inline(0x3F0F,dispatcher);
extern pascal void MenuBootInit() inline(0x010F,dispatcher);
extern pascal Word MenuGlobal () inline(0x230F,dispatcher);
extern pascal void MenuKey () inline(0x090F,dispatcher);
extern pascal void MenuNewRes () inline(0x290F,dispatcher);
extern pascal void MenuRefresh () inline(0x0B0F,dispatcher);
extern pascal void MenuReset() inline(0x050F,dispatcher);
extern pascal void MenuSelect () inline(0x2B0F,dispatcher);
extern pascal void MenuShutDown() inline(0x030F,dispatcher);
extern pascal void MenuStartUp() inline(0x020F,dispatcher);
extern pascal Boolean MenuStatus() inline(0x060F,dispatcher);
extern pascal Word MenuVersion() inline(0x040F,dispatcher);
extern pascal MenuRecHndl NewMenu () inline(0x2D0F,dispatcher);
extern pascal MenuRecHndl NewMenu2() inline(0x3E0F,dispatcher);
extern pascal MenuBarRecHndl NewMenuBar () inline(0x150F,dispatcher);
extern pascal MenuBarRecHndl NewMenuBar2() inline(0x430F,dispatcher);
extern pascal Word PopUpMenuSelect () inline(0x3C0F,dispatcher);
extern pascal void SetBarColors () inline(0x170F,dispatcher);
extern pascal void SetMenuBar () inline(0x390F,dispatcher);
extern pascal void SetMenuFlag () inline(0x1F0F,dispatcher);
extern pascal void SetMenuID () inline(0x370F,dispatcher);
extern pascal void SetMenuTitle () inline(0x210F,dispatcher);
extern pascal void SetMenuTitle2 () inline(0x400F,dispatcher);
extern pascal void SetMItem () inline(0x240F,dispatcher);
extern pascal void SetMItem2() inline(0x410F,dispatcher);
extern pascal void SetMItemBlink () inline(0x280F,dispatcher);
extern pascal void SetMItemFlag () inline(0x260F,dispatcher);
extern pascal void SetMItemID () inline(0x380F,dispatcher);
extern pascal void SetMItemMark () inline(0x330F,dispatcher);
extern pascal void SetMItemName () inline(0x3A0F,dispatcher);
extern pascal void SetMItemName2 () inline(0x420F,dispatcher);
extern pascal void SetMItemStyle () inline(0x350F,dispatcher);
extern pascal void SetMTitleStart () inline(0x190F,dispatcher);
extern pascal void SetMTitleWidth () inline(0x1D0F,dispatcher);
extern pascal void SetSysBar () inline(0x120F,dispatcher);
extern pascal void ShowMenuBar() inline(0x460F,dispatcher);
#endif
